# normal_plot3.r
# Normal probability densities

# Load necessary libraries
library(ggplot2)

# Three sets of normal parameters here
mu_1 <- 0
sig2_1 <- 1
mu_2 <- 2
sig2_2 <- 2
mu_3 <- 2
sig2_3 <- 0.5

# Minimum and maximum values of y
ymin <- -4
ymax <- 6
ystep <- 0.1

# Normal probability density function
y <- seq(ymin,ymax,ystep)
fy_1 <- dnorm(y,mu_1,sqrt(sig2_1))
fy_2 <- dnorm(y,mu_2,sqrt(sig2_2))
fy_3 <- dnorm(y,mu_3,sqrt(sig2_3))

# Make data frame for ggplot2
normdata <- as.data.frame(cbind(y,fy_1,fy_2,fy_3))

# Print data
normdata

# Plot probability density functions
ggplot(normdata,aes(x=y,y=fy_1))+
geom_line(color="black",size=1)+
geom_line(aes(y,fy_2),color="blue",size=1)+
geom_line(aes(y,fy_3),color="red",size=1)+
ggtitle("Normal probability densities")
